unit UnitDemo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, TaskDialogs, TaskDialogsComponent;

type
  TfmMain = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    LinkLabel1: TLinkLabel;
    TaskDialog1: TTaskDialog;
    TaskDialog2: TTaskDialog;
    TaskDialog3: TTaskDialog;
    TaskDialog4: TTaskDialog;
    TaskDialog5: TTaskDialog;
    Button6: TButton;
    TaskDialog6: TTaskDialog;
    Button7: TButton;
    TaskDialog7: TTaskDialog;
    Button8: TButton;
    TaskDialog8: TTaskDialog;
    Button9: TButton;
    TaskDialog9: TTaskDialog;
    Button10: TButton;
    TaskDialog10: TTaskDialog;
    Button11: TButton;
    TaskDialog11: TTaskDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure LinkLabel1LinkClick(Sender: TObject; const Link: string;
      LinkType: TSysLinkType);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure TaskDialog7Timer(Sender: TObject; TickCount: Cardinal;
      var Reset: Boolean);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure TaskDialog10HyperlinkClicked(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

uses
  ShellAPI;

{$R *.dfm}

procedure TfmMain.Button1Click(Sender: TObject);
begin
  TaskDialog1.Execute;
end;

procedure TfmMain.Button2Click(Sender: TObject);
begin
  TaskDialog2.Execute;
end;

procedure TfmMain.Button3Click(Sender: TObject);
begin
  TaskDialog3.Execute;
end;

procedure TfmMain.Button4Click(Sender: TObject);
begin
  TaskDialog4.Execute;
end;

procedure TfmMain.Button5Click(Sender: TObject);
begin
  TaskDialog5.Execute;
  if TaskDialog5.ModalResult = mrYes then
    ShowMessage('Yes clicked')
  else
    ShowMessage('No clicked');
end;

procedure TfmMain.Button6Click(Sender: TObject);
begin
  TaskDialog6.Execute;
end;

procedure TfmMain.Button7Click(Sender: TObject);
begin
  TaskDialog7.Execute;
  case TaskDialog7.ModalResult of
    mrCancel: ShowMessage('Cancelled');
    100: ShowMessage('Button 1 clicked');
    101: ShowMessage('Button 2 clicked');
    102: ShowMessage('Button 3 clicked');
  else
    Assert(False);
  end;
end;

procedure TfmMain.Button8Click(Sender: TObject);
begin
  TaskDialog8.Execute;
end;

procedure TfmMain.Button9Click(Sender: TObject);
begin
  TaskDialog9.Execute;
end;

procedure TfmMain.Button10Click(Sender: TObject);
begin
  TaskDialog10.Execute;
end;

procedure TfmMain.Button11Click(Sender: TObject);
begin
  TaskDialog11.Execute;
end;

procedure TfmMain.TaskDialog7Timer(Sender: TObject; TickCount: Cardinal; var Reset: Boolean);
var
  S: String;
begin
  if TickCount > 5000 then
    SendMessage(TaskDialog7.Handle, TDM_ENABLE_BUTTON, 101, 1)
  else
  begin
    S := 'Seconds left: ' + IntToStr(Round((5000 - TickCount)/1000));
    SendMessage(TaskDialog7.Handle, TDM_UPDATE_ELEMENT_TEXT, TDE_CONTENT, lParam(PChar(S)));
  end;
end;

procedure TfmMain.TaskDialog10HyperlinkClicked(Sender: TObject);
begin
  ShellExecute(TaskDialog10.Handle, 'open', PChar(TaskDialog10.URL), nil, nil, SW_NORMAL);
end;

procedure TfmMain.LinkLabel1LinkClick(Sender: TObject; const Link: string;
  LinkType: TSysLinkType);
begin
  ShellExecute(Handle, 'open', PChar(Link), nil, nil, SW_NORMAL);
end;

end.
