unit TaskDialogsComponent;

interface

uses
  Windows, Messages, SysUtils, Classes, Consts, ComCtrls, Controls, Graphics,
  Forms, ActiveX, WideStrUtils, Dialogs;

{$WARN SYMBOL_PLATFORM OFF}

type
  TCustomTaskDialog = class(Dialogs.TCustomTaskDialog)
  strict protected
    function DoExecute(ParentWnd: HWND): Boolean; override;
  end;

  TTaskDialog = class(Dialogs.TTaskDialog)
  strict protected
    function DoExecute(ParentWnd: HWND): Boolean; override;
  end;

implementation

uses
  TaskDialogs;

function AllocCoTaskMemStr(const S: string): LPCWSTR;
var
  Len: Integer;
begin
  Len := Length(S);
  Result := CoTaskMemAlloc((Len * SizeOf(WideChar)) + SizeOf(WideChar));
  Result := WStrPLCopy(Result, WideString(S), Len);
end;

type
  TTaskDlgIconMapType = PWideChar;

const
  CTaskDlgIcons: array[tdiNone..tdiShield] of TTaskDlgIconMapType = (
    nil,
    TD_WARNING_ICON, TD_ERROR_ICON, TD_INFORMATION_ICON, TD_SHIELD_ICON);

function TaskDialogCallbackProc(hwnd: HWND; msg: UINT; wParam: WPARAM;
  lParam: LPARAM; lpRefData: LONG_PTR): HResult; stdcall;
begin
  Result := TCustomTaskDialog(Pointer(lpRefData)).CallbackProc(hwnd, msg,
    wparam, lparam, 0);
end;

function TCustomTaskDialog.DoExecute(ParentWnd: HWND): Boolean;
const
  CTaskDlgFlags: array[TTaskDialogFlag] of Cardinal = (
    TDF_Enable_Hyperlinks, TDF_Use_Hicon_Main,
    tdf_Use_Hicon_Footer, TDF_ALLOW_DIALOG_CANCELLATION,
    TDF_USE_COMMAND_LINKS, TDF_USE_COMMAND_LINKS_NO_ICON,
    TDF_EXPAND_FOOTER_AREA, TDF_EXPANDED_BY_DEFAULT,
    TDF_VERIFICATION_FLAG_CHECKED, TDF_SHOW_PROGRESS_BAR,
    TDF_SHOW_MARQUEE_PROGRESS_BAR, TDF_CALLBACK_TIMER,
    TDF_POSITION_RELATIVE_TO_WINDOW, TDF_RTL_LAYOUT,
    TDF_NO_DEFAULT_RADIO_BUTTON, TDF_CAN_BE_MINIMIZED);

  CTaskDlgCommonButtons: array[TTaskDialogCommonButton] of Cardinal = (
    TDCBF_OK_BUTTON, TDCBF_YES_BUTTON, TDCBF_NO_BUTTON,
    TDCBF_CANCEL_BUTTON, TDCBF_RETRY_BUTTON, TDCBF_CLOSE_BUTTON);

  CTaskDlgDefaultButtons: array[TTaskDialogCommonButton] of Integer = (
    IDOK, IDYES, IDNO, IDCANCEL, IDRETRY, IDCLOSE);

var
  LWindowList: TTaskWindowList;
  LModalResult: Integer;
  LRadioButton: Integer;
  LFlag: TTaskDialogFlag;
  LFocusState: TFocusState;
  LVerificationChecked: LongBool;
  LTaskDialog: TTaskDialogConfig;
  LCommonButton: TTaskDialogCommonButton;
begin
  FillChar(LTaskDialog, SizeOf(LTaskDialog), 0);
  with LTaskDialog do
  begin
    // Set Size, Parent window, Flags
    cbSize := SizeOf(LTaskDialog);
    hwndParent := ParentWnd;
    dwFlags := 0;
    for LFlag := Low(TTaskDialogFlag) to High(TTaskDialogFlag) do
      if LFlag in Flags then
        dwFlags := dwFlags or CTaskDlgFlags[LFlag];

    // Set CommonButtons
    dwCommonButtons := 0;
    for LCommonButton := Low(TTaskDialogCommonButton) to High(TTaskDialogCommonButton) do
      if LCommonButton in CommonButtons then
        dwCommonButtons := dwCommonButtons or CTaskDlgCommonButtons[LCommonButton];

    // Set Content, MainInstruction, Title, MainIcon, DefaultButton
    if Text <> '' then
      pszContent := PWideChar(WideString(Text));
    if Title <> '' then
      pszMainInstruction := PWideChar(WideString(Title));
    if Caption <> '' then
      pszWindowTitle := PWideChar(WideString(Caption));
    if tfUseHiconMain in Flags then
      hMainIcon := CustomMainIcon.Handle
    else
    begin
      if MainIcon in [tdiNone..tdiShield] then
        pszMainIcon := LPCWSTR(CTaskDlgIcons[MainIcon])
      else
        pszMainIcon := LPCWSTR(MakeIntResourceW(Word(MainIcon)));
    end;
    nDefaultButton := CTaskDlgDefaultButtons[DefaultButton];

    // Set Footer, FooterIcon
    if FooterText <> '' then
      pszFooter := PWideChar(WideString(FooterText));
    if tfUseHiconFooter in Flags then
      hFooterIcon := CustomFooterIcon.Handle
    else
    begin
      if FooterIcon in [tdiNone..tdiShield] then
        pszFooterIcon := LPCWSTR(CTaskDlgIcons[FooterIcon])
      else
        pszFooterIcon := LPCWSTR(MakeIntResourceW(Word(FooterIcon)));
    end;

    // Set VerificationText, ExpandedInformation, CollapsedControlText
    if VerificationText <> '' then
      pszVerificationText := PWideChar(WideString(VerificationText));
    if ExpandedText <> '' then
      pszExpandedInformation := PWideChar(WideString(ExpandedText));
    if ExpandButtonCaption <> '' then
      pszCollapsedControlText := PWideChar(WideString(ExpandButtonCaption));

    // Set Buttons
    cButtons := Buttons.Count;
    if cButtons > 0 then
      pButtons := Pointer(Buttons.Buttons);
    if Buttons.DefaultButton <> nil then
      nDefaultButton := Buttons.DefaultButton.ModalResult;

    // Set RadioButtons
    cRadioButtons := RadioButtons.Count;
    if cRadioButtons > 0 then
      pRadioButtons := Pointer(RadioButtons.Buttons);
    if not (tfNoDefaultRadioButton in Flags) and (RadioButtons.DefaultButton <> nil) then
      nDefaultRadioButton := RadioButtons.DefaultButton.ModalResult;

    // Prepare callback
    lpCallbackData := LONG_PTR(Self);
    pfCallback := @TaskDialogCallbackProc;
  end;

  LWindowList := DisableTaskWindows(ParentWnd);
  LFocusState := SaveFocusState;
  try
    Result := TaskDialogIndirect(LTaskDialog, @LModalResult,
      @LRadioButton, @LVerificationChecked) = S_OK;
    ModalResult := LModalResult;
    if Result then
    begin
      Button := TTaskDialogButtonItem(Buttons.FindButton(ModalResult));
      PPointer(@RadioButton)^ := Pointer(RadioButtons.FindButton(LRadioButton));
      if LVerificationChecked then
        Flags := Flags + [tfVerificationFlagChecked];
    end;
  finally
    EnableTaskWindows(LWindowList);
    SetActiveWindow(ParentWnd);
    RestoreFocusState(LFocusState);
  end;
end;

{ TTaskDialog }

function TTaskDialog.DoExecute(ParentWnd: HWND): Boolean;
const
  CTaskDlgFlags: array[TTaskDialogFlag] of Cardinal = (
    TDF_Enable_Hyperlinks, TDF_Use_Hicon_Main,
    tdf_Use_Hicon_Footer, TDF_ALLOW_DIALOG_CANCELLATION,
    TDF_USE_COMMAND_LINKS, TDF_USE_COMMAND_LINKS_NO_ICON,
    TDF_EXPAND_FOOTER_AREA, TDF_EXPANDED_BY_DEFAULT,
    TDF_VERIFICATION_FLAG_CHECKED, TDF_SHOW_PROGRESS_BAR,
    TDF_SHOW_MARQUEE_PROGRESS_BAR, TDF_CALLBACK_TIMER,
    TDF_POSITION_RELATIVE_TO_WINDOW, TDF_RTL_LAYOUT,
    TDF_NO_DEFAULT_RADIO_BUTTON, TDF_CAN_BE_MINIMIZED);

  CTaskDlgCommonButtons: array[TTaskDialogCommonButton] of Cardinal = (
    TDCBF_OK_BUTTON, TDCBF_YES_BUTTON, TDCBF_NO_BUTTON,
    TDCBF_CANCEL_BUTTON, TDCBF_RETRY_BUTTON, TDCBF_CLOSE_BUTTON);

  CTaskDlgDefaultButtons: array[TTaskDialogCommonButton] of Integer = (
    IDOK, IDYES, IDNO, IDCANCEL, IDRETRY, IDCLOSE);

var
  LWindowList: TTaskWindowList;
  LModalResult: Integer;
  LRadioButton: Integer;
  LFlag: TTaskDialogFlag;
  LFocusState: TFocusState;
  LVerificationChecked: LongBool;
  LTaskDialog: TTaskDialogConfig;
  LCommonButton: TTaskDialogCommonButton;
begin
  FillChar(LTaskDialog, SizeOf(LTaskDialog), 0);
  with LTaskDialog do
  begin
    // Set Size, Parent window, Flags
    cbSize := SizeOf(LTaskDialog);
    hwndParent := ParentWnd;
    dwFlags := 0;
    for LFlag := Low(TTaskDialogFlag) to High(TTaskDialogFlag) do
      if LFlag in Flags then
        dwFlags := dwFlags or CTaskDlgFlags[LFlag];

    // Set CommonButtons
    dwCommonButtons := 0;
    for LCommonButton := Low(TTaskDialogCommonButton) to High(TTaskDialogCommonButton) do
      if LCommonButton in CommonButtons then
        dwCommonButtons := dwCommonButtons or CTaskDlgCommonButtons[LCommonButton];

    // Set Content, MainInstruction, Title, MainIcon, DefaultButton
    if Text <> '' then
      pszContent := PWideChar(WideString(Text));
    if Title <> '' then
      pszMainInstruction := PWideChar(WideString(Title));
    if Caption <> '' then
      pszWindowTitle := PWideChar(WideString(Caption));
    if tfUseHiconMain in Flags then
      hMainIcon := CustomMainIcon.Handle
    else
    begin
      if MainIcon in [tdiNone..tdiShield] then
        pszMainIcon := LPCWSTR(CTaskDlgIcons[MainIcon])
      else
        pszMainIcon := LPCWSTR(MakeIntResourceW(Word(MainIcon)));
    end;
    nDefaultButton := CTaskDlgDefaultButtons[DefaultButton];

    // Set Footer, FooterIcon
    if FooterText <> '' then
      pszFooter := PWideChar(WideString(FooterText));
    if tfUseHiconFooter in Flags then
      hFooterIcon := CustomFooterIcon.Handle
    else
    begin
      if FooterIcon in [tdiNone..tdiShield] then
        pszFooterIcon := LPCWSTR(CTaskDlgIcons[FooterIcon])
      else
        pszFooterIcon := LPCWSTR(MakeIntResourceW(Word(FooterIcon)));
    end;

    // Set VerificationText, ExpandedInformation, CollapsedControlText
    if VerificationText <> '' then
      pszVerificationText := PWideChar(WideString(VerificationText));
    if ExpandedText <> '' then
      pszExpandedInformation := PWideChar(WideString(ExpandedText));
    if ExpandButtonCaption <> '' then
      pszCollapsedControlText := PWideChar(WideString(ExpandButtonCaption));

    // Set Buttons
    cButtons := Buttons.Count;
    if cButtons > 0 then
      pButtons := Pointer(Buttons.Buttons);
    if Buttons.DefaultButton <> nil then
      nDefaultButton := Buttons.DefaultButton.ModalResult;

    // Set RadioButtons
    cRadioButtons := RadioButtons.Count;
    if cRadioButtons > 0 then
      pRadioButtons := Pointer(RadioButtons.Buttons);
    if not (tfNoDefaultRadioButton in Flags) and (RadioButtons.DefaultButton <> nil) then
      nDefaultRadioButton := RadioButtons.DefaultButton.ModalResult;

    // Prepare callback
    lpCallbackData := LONG_PTR(Self);
    pfCallback := @TaskDialogCallbackProc;
  end;

  LWindowList := DisableTaskWindows(ParentWnd);
  LFocusState := SaveFocusState;
  try
    Result := TaskDialogIndirect(LTaskDialog, @LModalResult,
      @LRadioButton, @LVerificationChecked) = S_OK;
    ModalResult := LModalResult;
    if Result then
    begin
      Button := TTaskDialogButtonItem(Buttons.FindButton(ModalResult));
      PPointer(@RadioButton)^ := Pointer(RadioButtons.FindButton(LRadioButton));
      if LVerificationChecked then
        Flags := Flags + [tfVerificationFlagChecked];
    end;
  finally
    EnableTaskWindows(LWindowList);
    SetActiveWindow(ParentWnd);
    RestoreFocusState(LFocusState);
  end;
end;

end.
